"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAliases = void 0;
exports.getAliasesRoute = getAliasesRoute;
var _configSchema = require("@kbn/config-schema");
var _errors = require("../../lib/errors");
var _constants = require("../../../../../common/signals/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const getAliases = ({
  clusterClient,
  logger
}) => async (context, request, response) => {
  try {
    const {
      alias
    } = request.body;
    const resp = await clusterClient.asScoped(request).asCurrentUser.cat.aliases({
      alias,
      format: 'json',
      h: 'alias,index'
    });
    return response.ok({
      body: {
        ok: true,
        resp
      }
    });
  } catch (err) {
    logger.error(`getAliases: ${err.stack}`);
    return response.customError((0, _errors.serverError)(err));
  }
};
exports.getAliases = getAliases;
function getAliasesRoute({
  router,
  clusterClient,
  logger
}) {
  router.post({
    path: `${_constants.BASE_URI}/_aliases`,
    validate: {
      body: _configSchema.schema.object({
        alias: _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.arrayOf(_configSchema.schema.string())])
      })
    }
  }, getAliases({
    clusterClient,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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